define([
    'App',
    'backbone',
    'underscore',
    'jquery',
    'modules/appointments/booked/appointment-cancel-reason-section-view',
    'Layout',
], function(App, Backbone, _, $, View, Layout) {
    'use strict';


    describe('Appointment Cancel Reason Section View', function() {
        var view;
        var model;
        var data;
        var layout;

        var CONSTANTS = Object.create({}, {
            CONTAINER_CLASS: {value: 'cancel-reason-test'},
            EMPTY_STRING: {value: ''},
            BODY: {value: $('body')},
        });


        beforeEach(function() {
            var $div;
            layout = new Layout();
            model = new Backbone.Model({cancelAppointment: false});
            data = {
                validator: 'validator',
                cancelReasonList: new Backbone.Collection([
                    {should: 'this'},
                    {even: 'be'},
                    {a: 'collection'},
                ]),
                model: model,
            };

            $div = $('<div>');
            $div.addClass(CONSTANTS.CONTAINER_CLASS);

            CONSTANTS.BODY.append($div);
        });

        afterEach(function() {
            if (view && view.destroy) {
                view.destroy();
            }
            $('.' + CONSTANTS.CONTAINER_CLASS).remove();
        });

        it('initializes the view with correct parameters', function() {
            var isEventListenerInitialized = false;

            // Overriding a parent function
            var TempView = View.extend({
                initializeQuestionEventListeners: function() {
                    isEventListenerInitialized = true;
                },
            });

            view = new TempView(data);

            // There is a legend in the json data for this but it is nested on questions
            expect(view.legend).toEqual(CONSTANTS.EMPTY_STRING);
            expect(view.collection.length).toBe(1);
            expect(view.collection.get('cancelReason').get('values')).toEqual(data.cancelReasonList.toJSON());
            expect(isEventListenerInitialized).toBe(true);
            expect(view.validator).toBe(data.validator);
        });

        it('calls the parent method initChildren on show', function() {
            var isParentMethodCalled = false;

            view = new View(data);
            view.showHideChildrenQuestionsAndValidation = _.noop;
            view.initChildren = function() {
                isParentMethodCalled = true;
            };
            view.triggerMethod('render');

            expect(isParentMethodCalled).toBe(true);
        });

        it('fires the correct function on model change events', function() {
            var isToggleTriggered = false;

            // Overriding a function to detect if it is called.
            var TempView = View.extend({
                showHideChildrenQuestionsAndValidation: function() {
                    isToggleTriggered = true;
                },
            });

            view = new TempView(data);
            view.model.set('cancelAppointment', true);

            expect(isToggleTriggered).toBe(true);
        });

        it('shows the children correctly', function() {
            var _view = new View(_.extend(data, {validator: null}));
            layout.render();
            layout.showChildView('content', _view);
            // cancel reasons drop down will be displayed by default
            expect(_view.$('.selectmenu-question').hasClass('hidden')).toBe(false);

        });
    });
});
